<?php

return [
    /* Store Related Config Values
    --------------------------------------------------------------------------*/

    'currencies' => [

        /* Zero-decimal currencies
        ----------------------------------------------------------------------*/
        'zero_decimal' => [
            'BIF' => 'Burundian Franc',
            'CLP' => 'Chilean Peso',
            'DJF' => 'Djiboutian Franc',
            'GNF' => 'Guinean Franc',
            'JPY' => 'Japanese Yen',
            'KMF' => 'Comorian Franc',
            'KRW' => 'South Korean Won',
            'MGA' => 'Malagasy Ariary',
            'PYG' => 'Paraguayan Guaraní',
            'RWF' => 'Rwandan Franc',
            'VND' => 'Vietnamese Đồng',
            'VUV' => 'Vanuatu Vatu',
            'XAF:' => 'Central African Cfa Franc',
            'XOF' => 'West African Cfa Franc',
            'XPF' => 'Cfp Franc',
            // Paypal zero-decimal currencies
            'HUF' => 'Hungarian Forint',
            'TWD' => 'New Taiwan Dollar',
        ],

        'options' => [
            'AUD' => ('Australian Dollar'),
            'CAD' => ('Canadian Dollar'),
            'EUR' => ('Euro'),
            'GBP' => ('British Pound'),
            'USD' => ('U.S. Dollar'),
            'NZD' => ('New Zealand Dollar'),
            'CHF' => ('Swiss Franc'),
            'HKD' => ('Hong Kong Dollar'),
            'SGD' => ('Singapore Dollar'),
            'SEK' => ('Swedish Krona'),
            'DKK' => ('Danish Krone'),
            'PLN' => ('Polish Zloty'),
            'NOK' => ('Norwegian Krone'),
            'HUF' => ('Hungarian Forint'),
            'CZK' => ('Czech Koruna'),
            'ILS' => ('Israeli New Shekel'),
            'MXN' => ('Mexican Peso'),
            'BRL' => ('Brazilian Real (only for Brazilian members)'),
            'MYR' => ('Malaysian Ringgit (only for Malaysian members)'),
            'PHP' => ('Philippine Peso'),
            'TWD' => ('New Taiwan Dollar'),
            'THB' => ('Thai Baht'),
            'TRY' => ('Turkish Lira (only for Turkish members)'),
            'INR' => ('Indian Rupee)'),
            '' => ('Other'),
        ],
        'details' => [

            'AUD' => [
                'name' => ('Australian Dollar'),
                'symbol' => 'A$',
                'ASCII' => 'A&#36;',
            ],

            'CAD' => [
                'name' => ('Canadian Dollar'),
                'symbol' => '$',
                'ASCII' => '&#36;',
            ],

            'CZK' => [
                'name' => ('Czech Koruna'),
                'symbol' => 'Kč',
                'ASCII' => 'K&#x10d;',
            ],

            'DKK' => [
                'name' => ('Danish Krone'),
                'symbol' => 'Kr',
                'ASCII' => 'K&#x72;',
            ],

            'EUR' => [
                'name' => ('Euro'),
                'symbol' => '€',
                'ASCII' => '&euro;',
            ],

            'HKD' => [
                'name' => ('Hong Kong Dollar'),
                'symbol' => '$',
                'ASCII' => '&#36;',
            ],

            'HUF' => [
                'name' => ('Hungarian Forint'),
                'symbol' => 'Ft',
                'ASCII' => 'F&#x74;',
            ],

            'ILS' => [
                'name' => ('Israeli New Sheqel'),
                'symbol' => '₪',
                'ASCII' => '&#8361;',
            ],

            'JPY' => [
                'name' => ('Japanese Yen'),
                'symbol' => '¥',
                'ASCII' => '&#165;',
            ],

            'MXN' => [
                'name' => ('Mexican Peso'),
                'symbol' => '$',
                'ASCII' => '&#36;',
            ],

            'NOK' => [
                'name' => ('Norwegian Krone'),
                'symbol' => 'Kr',
                'ASCII' => 'K&#x72;',
            ],

            'NZD' => [
                'name' => ('New Zealand Dollar'),
                'symbol' => '$',
                'ASCII' => '&#36;',
            ],

            'PHP' => [
                'name' => ('Philippine Peso'),
                'symbol' => '₱',
                'ASCII' => '&#8369;',
            ],

            'PLN' => [
                'name' => ('Polish Zloty'),
                'symbol' => 'zł',
                'ASCII' => 'z&#x142;',
            ],

            'GBP' => [
                'name' => ('Pound Sterling'),
                'symbol' => '£',
                'ASCII' => '&#163;',
            ],

            'SGD' => [
                'name' => ('Singapore Dollar'),
                'symbol' => '$',
                'ASCII' => '&#36;',
            ],

            'SEK' => [
                'name' => ('Swedish Krona'),
                'symbol' => 'kr',
                'ASCII' => 'K&#x72;',
            ],

            'CHF' => [
                'name' => ('Swiss Franc'),
                'symbol' => 'CHF',
                'ASCII' => '&#x43;&#x48;&#x46;',
            ],

            'TWD' => [
                'name' => ('Taiwan New Dollar'),
                'symbol' => 'NT$',
                'ASCII' => 'NT&#36;',
            ],

            'THB' => [
                'name' => ('Thai Baht'),
                'symbol' => '฿',
                'ASCII' => '&#3647;',
            ],

            'USD' => [
                'name' => ('U.S. Dollar'),
                'symbol' => '$',
                'ASCII' => '&#36;',
            ],
            'TRY' => [
                'name' => ('Turkish Lira'),
                'symbol' => '₺',
                'ASCII' => '&#x20BA;',
            ],
            'INR' => [
                'name' => ('Indian Rupee'),
                'symbol' => '₹',
                'ASCII' => '&#8377;',
            ],
            'NGN' => [
                'name' => ('Nigerian naira'),
                'symbol' => '₦',
                'ASCII' => '&#8358;',
            ],
        ],
    ],
];
